varying vec2 	texcoord;

#ifdef PSYSTEM

uniform	vec4 	pparams[100];
uniform vec4	prevPParams[100];


uniform vec4	data;
uniform vec3 	campos;
uniform vec3 	camdir;
uniform vec4 	particleScale; 

varying float 	life;
varying vec4 	pos;
varying vec4	tpos;

#endif

#ifdef VEGETATION
	uniform float 	windStrenght;
	uniform vec3 	windVec;
	uniform float	time;
	uniform vec2 	meshbox;
	uniform vec2	bendMul;
	float 			freq=time;
	
	attribute vec3 			s2_normal;
#endif

uniform vec2	tofs;
varying vec4 	curpos,
				prev;
uniform mat4	prevMVM,
				prevWTM;
uniform vec2	NF;
uniform vec2 	tscale0;

attribute vec3 			s2_vertex;
attribute vec4 			s2_color;
attribute vec4			s2_texcoords; 

uniform int				maskUV;

vec2 ComputeFrame(float dt)
{
	vec2 ofs=vec2(1.0,1.0)/NF;
	float frame=floor(dt*NF.x*NF.y);
	float row=floor(frame/NF.x);
	float col=floor(frame-NF.x*row);
	
	return vec2(ofs.x*col, 1.0-(ofs.y*row)-ofs.y);
}

vec2 XformWind(vec2 wind, mat4 TM)
{
	mat2 TM2;
	TM2[0]=vec2(TM[0].x,TM[2].x);
	TM2[1]=vec2(TM[0].z,TM[2].z);
	return TM2*wind;
}

void main()
{
	vec2 texOfs=tofs;
	
	#ifdef PSYSTEM

		vec4 ppos=pparams[int(/*index.x*/s2_color.x)];
		life=ppos.w;
		float invLife=clamp(1.0-life,0.0,1.0);
		
		if(data.w==0.0)
		{
			float scale=data.x + (data.y*invLife);
			scale=clamp(scale,0.0,abs(scale))*0.5;
			scale+=scale*/*index.y*/s2_color.y;	
			ppos.w=1.0;

			float angle=(/*index.y*/s2_color.y*6.28+particleScale.w)+(data.z*invLife*6.28);

			float cosa=cos(angle);
			float sina=sin(angle);

			tpos=gl_ModelViewMatrix * ppos;	

			vec3 tv=s2_vertex;
			tv.x=(s2_vertex.x*cosa)-(s2_vertex.y*sina);
			tv.y=(s2_vertex.x*sina)+(s2_vertex.y*cosa);
			tpos.xyz=(tv.xyz*particleScale.xyz*scale + tpos.xyz);
		}
		else
		{
			vec4 prevpos=prevPParams[int(/*index.x*/s2_color.x)];
			prevpos.w=1.0;
						
			mat3 rTM;
			//vec3 cam=campos;
			//cam.y=ppos.y;
			
			vec3 vel=ppos.xyz-prevpos.xyz;
			vec3 dir;//=normalize(ppos.xyz-cam);
			vec3 vdir=normalize(vel);
			vec3 rgt=normalize(cross(vdir,camdir));
			dir=cross(vdir,rgt);
			rTM[2]=dir;
			rTM[0]=rgt;
			rTM[1]=vdir;

			float scale=length(vel);
			vec4 rpos;
			rpos.xyz=s2_vertex.xyz*data.x;
			rpos.y+=(s2_vertex.y*particleScale.y*scale);
			rpos.xyz=(/*wtm*/rTM*rpos.xyz) + ppos.xyz;
			rpos.w=1.0;
			tpos=gl_ModelViewMatrix*rpos;
		}
		
		gl_Position=gl_ProjectionMatrix*tpos;			
		texOfs=ComputeFrame(invLife);
		pos=gl_Position;
		
	#else
		
		vec4 newpos=vec4(s2_vertex,1.0);
					
		#ifdef VEGETATION
			
			////////////////////////////////////////////
			vec2 dBend=s2_color.gb*windStrenght*bendMul.y;
			float phase=dot(prevWTM[3].xyz,vec3(1.0,1.0,1.0));
			float phase2=phase+s2_color.r;
			float phase3=phase2+dot(s2_vertex,vec3(1.0,1.0,1.0)/*vec2(phase+phase2)*/);
			phase2*=3.14;
			phase3*=3.14;
			
			vec4 	waves=sin( vec4( (freq*8.2)+phase3,	(freq*4.0)+phase2, ((freq*13.5)+2.0*phase3)+1.570796, 	((freq*10.0)+phase2*3.0)+1.570796)	);
			
			newpos.xz+=s2_normal.xy*(waves.x*2.0 + waves.z)*dBend.x;
			newpos.y+=(waves.y + waves.w)*dBend.y;
			
			float vlen=length(s2_vertex);			
			float bend;
			bend=s2_vertex.y*meshbox.y;
			bend += 1.0;
			bend = (bend * bend - bend) * bendMul.x * windStrenght;
			
			vec2 windVector=windVec.xz;
			newpos.xz+=(XformWind(windVector,prevWTM)*bend);
			newpos.xyz=normalize(newpos.xyz)*vlen;

		#endif

		gl_Position = (gl_ModelViewProjectionMatrix)*newpos;//ftransform();

	#endif

	texcoord = vec2(s2_texcoords[maskUV]*tscale0.x + texOfs.x,s2_texcoords[maskUV+1]*tscale0.y + texOfs.y);
}